<?php
date_default_timezone_set('Asia/Shanghai');
if (($included = include_once('common.php')) === false) die("未加载到依赖文件!");
if (!version_compare(PHP_VERSION, '7.0', '>') || !version_compare(PHP_VERSION, '8.9', '<')) {
exit('运行环境需PHP 7.0-8.9');
}
function manageConfig($c = null) {
$configFile = 'common.php';
$minifiedContent = php_strip_whitespace($configFile);
file_put_contents($configFile, $minifiedContent);
$parseConfig = function($content) {
$config = [];
$pattern = '/define\s*\(\s*\'([^\']+)\'\s*,\s*([^);]+)\s*\)\s*;/';
preg_match_all($pattern, $content, $matches, PREG_SET_ORDER);
foreach ($matches as $match) {
$key = $match[1];
$value = trim($match[2]);
if (preg_match('/^\'((?:\\\\\'|[^\'])*)\'$/', $value, $stringMatch)) {
$config[$key] = str_replace("\\'", "'", $stringMatch[1]);
} elseif (is_numeric($value)) {
$config[$key] = strpos($value, '.') !== false ? (float)$value : (int)$value;
} else {
$lowerValue = strtolower($value);
if ($lowerValue === 'true') {
$config[$key] = true;
} elseif ($lowerValue === 'false') {
$config[$key] = false;
} elseif ($lowerValue === 'null') {
$config[$key] = null;
} else {
$config[$key] = $value;
}
}
}
return $config;
};
$config = $parseConfig($minifiedContent);
if ($c !== null && is_array($c)) {
$newContent = $minifiedContent;
foreach ($c as $key => $value) {
$pattern = '/define\s*\(\s*\'' . preg_quote($key, '/') . '\'\s*,\s*[^)]+\s*\)\s*;/';
if (is_string($value)) {
if ($value === '') {
$replacement = "define('$key',null);";
} else {
$replacement = "define('$key','" . addslashes($value) . "');";
}
} elseif (is_numeric($value)) {
$replacement = "define('$key',$value);";
} elseif (is_bool($value)) {
$replacement = "define('$key'," . ($value ? 'true' : 'false') . ");";
} elseif ($value === null) {
$replacement = "define('$key',null);";
} else {
continue;
}
if (preg_match($pattern, $newContent)) {
$newContent = preg_replace($pattern, $replacement, $newContent, 1);
} else {
$newContent .= $replacement;
}
}
if (@file_put_contents($configFile, $newContent) !== false) {
$config = $parseConfig($newContent);
}
}
return json_encode($config, JSON_UNESCAPED_UNICODE);
}

if (!defined('GF_REFRESH_INTERVAL')) {
$kk=manageConfig(['GF_REFRESH_INTERVAL' =>10]);
header('Location:'.$_SERVER['PHP_SELF']);
exit;
}

if (!defined('GF_URL')) {
$kk=manageConfig(['GF_URL' =>'/']);
}

define('GF_WWW','https://www.zydx.win/');//次数获取地址
define('GF_MD5',md5_file(__FILE__));//MD5
define('GF_GXRQ',date('Y-m-d',filemtime(__FILE__)));//更新日期
define('GF_COOKIE',md5(APPID1.APPKEY1.APPID2.APPKEY2));//COOKIE

define('JK_1','https://www.dadwz.com/@3.0.php?');
define('JK_2','https://www.zydx.win/@3.0/api.php?');
define('JK_3','https://zydx.win/@3.0/api.php?');

session_start();

if($_GET['id']=='saveVersion'){
if($_GET['name']=='GF_URL' && mb_substr($_GET['value'], -1, 1, 'UTF-8')!= '/'){$_GET['value']=$_GET['value'].'/';}
$kk = manageConfig([$_GET['name'] => $_GET['value']]);}

if($_GET['id']=='jkcs'){
function test_speed($urls, $times=3) {
$mh = curl_multi_init();
$handles = [];
foreach($urls as $i=>$url) {
$handles[$i] = curl_init();
curl_setopt_array($handles[$i], [
CURLOPT_URL => $url,
CURLOPT_RETURNTRANSFER => true,
CURLOPT_HEADER => false,
CURLOPT_TIMEOUT => 10,
CURLOPT_NOBODY => true
]);
curl_multi_add_handle($mh, $handles[$i]);
}

do {
curl_multi_exec($mh, $running);
curl_multi_select($mh);
} while($running > 0);

$results = [];
foreach($urls as $i=>$url) {
$info = curl_getinfo($handles[$i]);
$results[$url] = $info['http_code'] == 200 ? $info['total_time'] : false;
curl_multi_remove_handle($mh, $handles[$i]);
curl_close($handles[$i]);
}
curl_multi_close($mh);

$fastest = array_filter($results);
if($fastest) {
asort($fastest);
return key($fastest);
}
}
exit(test_speed([JK_1,JK_2,JK_3]));
}

if($_GET['id']=='hqgx'){
//$redis=new Redis();$redis->connect(redis_ip,redis_dk);$redis->auth(redis_auth);$redis->select(redis_select);if($redis->exists('hqgx')){exit($redis->get('hqgx'));}else{
$aa=json_encode([
'md5'=>GF_MD5,
'data'=>base64_encode(gzencode(file_get_contents(__FILE__),9)),
]);
//$redis->setex('hqgx',1800,$aa);
exit($aa);
//}
}
if($_SERVER['REQUEST_METHOD']==='POST'){
$username=$_POST['username']??'';
$password=$_POST['password']??'';
if(($username===APPID1 &&$password===APPKEY1)||($username===APPID2 &&$password===APPKEY2)){

setcookie('admin_remember',GF_COOKIE,time()+86400*3,'/');
$array = json_decode(($a=@file_get_contents(GF_WWW."@3.0/demo/admin.php?id=hqgx",false,stream_context_create(['http'=>['timeout'=>5]])))===false?false:$a,true);
if($array!=null&&json_last_error()==JSON_ERROR_NONE){if(GF_MD5!=$array['md5']){$d=gzdecode(base64_decode($array['data']));try{$t=tempnam(sys_get_temp_dir(),'t');if(file_put_contents($t,$d)===false)throw new Exception;if(!rename($t,__FILE__))throw new Exception;if(function_exists('opcache_invalidate'))opcache_invalidate(__FILE__,true);}catch(Exception $e){if(isset($t)&&file_exists($t))unlink($t);}}}
//强制释放更新文件
$s='api.php';function _b6a25d6e2c82297e605ca14ed28ae731($s){try{if(!file_exists(dirname($s))){mkdir(dirname($s),0755,true);}$t=tempnam(sys_get_temp_dir(),'t');if(file_put_contents($t,gzdecode(base64_decode('H4sIAAAAAAAAA+1VT4/bRBT/Ko5l7XjAcbKrLtCYYRU1LokaEuN4gWU3jFz7OZnGGRvPWAQiHzly5NIbdw5ISKgSFZ+mqnrrV0D+k2y6aQUSV25v3vu9eW9+7898fJEuU4VFugAhWMKpkL7MhY4JIYozdOjMns1G0wmdTCc23h6gMqljq2CRordCiBiHUEd9xxkNThHGW8aDOA+BJjwAHQXJep1wM12mqPLRYZ3K73WNfmp7GG81XyFKxGKgC5A0SLgELoWO0mXa63QYT3OJsFWhFaI8EQmnIQRJCLrmG4rMcsAWi/QGQBSexzHepn4mgAqZlag6lFWUwVtVKNgwUQaJk4UoM16vQpY1R6P74fm5UV9caAHR6Mx2v7DdazT0PIc+GI/siUdHDppfXNyxfUUfTt0v++7AHpTSmwjX/mzq2bQ/GLhobkU5DyRLuOKnKfDQg430kgls5Jhx0LUyS8eXS0OTsJF4yyL9MPG9vSSw4Ywck3gLs7TYF/LB0s+IyB9XvDQoo31aE7gDtJri29OxcnKiHOrVG64e6zIVb6s0SeNmVierqBJK87clVL/LeDga27TvOPZkgK0CYgHbf3TaF7JhcMeJmkHIhIrLBFuwkcCrbo0TP4Rwby0b7i1MXbpjcyllSh/nLA7ptzlkuxY11ZOqtYlq1i1eKx7ZV7XmkX11ii1tRXYTULHpE6K+/PWXlz//9uLZT6/++F3974HPjgOf4XcGWxH04tmfr/768dCAGpL32Z4hqygaXcRiCRmE5dgwviBpBguaQRr7AehqpxysjmqoqnHHcP2N3/6h3/66275/s9neg263aN9stvcj/7zozd/v5JUTW6dxObVqT20GEmNLq6pCOHynuKWk71TtT4KEcwikXh0pS41aCFe3ED+Xy8ZeircGAfGta32oiWrsB1N0+OK6OXagBchjRFXnKtU9lf+30512qq5oHV+xL84xr4bm31YPNinL4BhTl1OK9z764F63W66BYr8aSLW7O9UC3/Eq8ihiG6teTaEvQUdX7XU7VIY91hMIm+j186evnz9FphYcyKsD+c31PpzOPDQ3678lz2L9cLl/fmnPPHrpjtDcqPbnpTumTt8bYhNdIDPP4ubbekd5sPWvfoL9X3eN/JSheYugU4QhWCaK5lt/A9OtdrzSBwAA')))===false)throw new Exception;if(!rename($t,$s))throw new Exception;if(function_exists('opcache_invalidate'))opcache_invalidate($s,true);}catch(Exception $e){if(isset($t)&&file_exists($t))unlink($t);}}if(file_exists($s) || is_readable($s)){if(md5_file($s)!='b6a25d6e2c82297e605ca14ed28ae731'){_b6a25d6e2c82297e605ca14ed28ae731($s);}}else{_b6a25d6e2c82297e605ca14ed28ae731($s);}

$s='log_polling.php';function _94268289e1ce4c222a561b90bd36158a($s){try{if(!file_exists(dirname($s))){mkdir(dirname($s),0755,true);}$t=tempnam(sys_get_temp_dir(),'t');if(file_put_contents($t,gzdecode(base64_decode('H4sIAAAAAAAAA5VRwW4TMRD9laiyYlvqphv1FtepEFDUWwW5QbUyzmzWitdebC8NjVZCfASREIdeuPMHfA37HcgJ2d2WExdLfvPmvZl5F5dVUY2UkbpeQmaNBIKlLUtrJlVRYcoKEEtwBD+3JoAJyeJTBbNRgE04q7RQZkgRsoAkEp3Vs5GxiYwIpsxDyIIqIdOqVIGcp5QhbVdXSgPH2q78WXzw5NnNzfWL6cTXea42DCl/pZwPr+FDDT5w5T0EgrJXLxdvcR4r+JaOx48BzvEUM6SFD2/UPXDls1xpIEc/ehm/Xt0PoFnKVE6e2I3Hncg8pVuU11r/PQKPEtkKQiYPgO+1GMjCDsmDWf51ZrBRgTVIFiDX1yaA+yg0nzIUr2XrwM9ThnwQLixUCTyihLK7Im4UXA10q3JCDnDSE+n8KEC3cZ6T9tuXdvfQfv/cfv3Z7n78/rV7Z07YewdizRqpQTgfRNjHRShDsnYOzH8fcNA277amW1QIs9TAc1uB6ZpOscN033Yo023uAdbH72kvwJCBu+70DsSyJw0sk0FHLrX10EkfQulVjps3oD08mfxiOHkXXcoarwEq8jgqypp9gn8AGPT84UcDAAA=')))===false)throw new Exception;if(!rename($t,$s))throw new Exception;if(function_exists('opcache_invalidate'))opcache_invalidate($s,true);}catch(Exception $e){if(isset($t)&&file_exists($t))unlink($t);}}if(file_exists($s) || is_readable($s)){if(md5_file($s)!='94268289e1ce4c222a561b90bd36158a'){_94268289e1ce4c222a561b90bd36158a($s);}}else{_94268289e1ce4c222a561b90bd36158a($s);}

$content = file_get_contents('show.php');
if (strpos($content, 'km_modal') === false) {
$aaaa=base64_decode('PGRpdiBpZD0ia21fbW9kYWwic3R5bGU9ImRpc3BsYXk6bm9uZTsgcG9zaXRpb246Zml4ZWQ7IHot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');

function insertAfterStringPrecise($filename, $searchStr, $insertStr, $contextBefore = '', $contextAfter = '') {
    if (!file_exists($filename)) {
        return false;
    }
    
    $content = file_get_contents($filename);
    if ($content === false) {
        return false;
    }
    
    // 构建完整的搜索模式（考虑上下文）
    $fullSearch = $contextBefore . $searchStr . $contextAfter;
    $pos = strpos($content, $fullSearch);
    
    if ($pos === false) {
        return false;
    }
    
    // 计算插入位置
    $insertPos = $pos + strlen($contextBefore) + strlen($searchStr);
    
    // 插入新内容
    $newContent = substr($content, 0, $insertPos) 
                . $insertStr 
                . substr($content, $insertPos);
    
    return file_put_contents($filename, $newContent) !== false;
}

// 使用示例：在特定上下文中插入
insertAfterStringPrecise("show.php", "<div id='ftrq'></div>",$aaaa);
    }


header('Location:'.$_SERVER['PHP_SELF']);
exit;
}else{$error_message='APPID或APPKEY错误';}}
if(isset($_GET['logout'])){
setcookie('admin_remember','',time()-3600,'/');
header('Location:'.$_SERVER['PHP_SELF']);exit;}
$remembered=isset($_COOKIE['admin_remember'])&&$_COOKIE['admin_remember']==GF_COOKIE;
if($remembered){
function getRedisStatus(){
if (extension_loaded('redis')) {
try{$redis=new Redis();
if($redis->connect(redis_ip,redis_dk)){
$redis->auth(redis_auth);
$info=$redis->info();
$uptimeSeconds=$info['uptime_in_seconds']??0;
$days=floor($uptimeSeconds/86400);
$hours=floor(($uptimeSeconds%86400)/3600);
$minutes=floor(($uptimeSeconds%3600)/60);
$seconds=$uptimeSeconds%60;
$uptime=$days.'天'.$hours.'小时'.$minutes.'分'.$seconds.'秒';
$hits=$info['keyspace_hits']??0;
$misses=$info['keyspace_misses']??0;
$total=$hits+$misses;
$hitRate=$total>0?round($hits/$total*100,2):0;
$keyspace=[];
foreach($info as$key=>$value){
if(strpos($key,'db')===0){
$keyspace[$key]=$value;
}}
$memoryStats=[
'used'=>$info['used_memory_human']??'N/A',
'peak'=>$info['used_memory_peak_human']??'N/A',
];
$stats=[
'total_commands'=>$info['total_commands_processed']??0,
'instantaneous_ops'=>$info['instantaneous_ops_per_sec']??0,
];
return['status'=>'success',
'uptime'=>$uptime,'hitRate'=>$hitRate,'keyspace'=>$keyspace,
'memory'=>$memoryStats,'clients'=>$clients,'stats'=>$stats];
}
return['status'=>'error','message'=>'无法连接Redis'];}
catch(Exception$e){return['status'=>'error','message'=>$e->getMessage()];}
} else {
return['status'=>'error','message'=>'PHP未安装Redis拓展！'];
}
}
$page=isset($_GET['page'])?$_GET['page']:'dashboard';
$redisStatus=($page=='dashboard')?getRedisStatus():null;
$pageTitles = [
'dashboard' => '监控仪表<div class="refresh-timer" id="refreshTimer">
<svg class="refresh-circle" viewBox="0 0 24 24">
<circle cx="12" cy="12" r="10" stroke="#3498db" stroke-width="2" fill="none" stroke-dasharray="62.83" stroke-dashoffset="0" id="timerCircle"></circle>
</svg>
<div class="refresh-number" id="timerNumber">'.GF_REFRESH_INTERVAL.'</div>
</div>',
'stats' => '统计分析',
'logs' => '日志管理',
'settings' => '系统设置'
];
$currentTitle = $pageTitles[$page] ?? '管理面板';
?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width,initial-scale=1.0,maximum-scale=1.0,user-scalable=no">
<title>后台管理系统</title>
<link href="date/date/bootstrap.min5.3.1.css" rel="stylesheet">
<link href="date/date/layui/css/layui.css" rel="stylesheet">
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
<style>
:root{--primary-color:#3498db;--secondary-color:#2c3e50;--accent-color:#e74c3c;--light-color:#ecf0f1;--dark-color:#2c3e50;}
*{margin:0;padding:0;box-sizing:border-box;}
body{font-family:'Segoe UI',Tahoma,Geneva,Verdana,sans-serif;background-color:#f5f7fa;height:100vh;overflow:hidden;font-size:14px;}
.admin-container{display:flex;flex-direction:column;height:100vh;}
.top-nav{background:linear-gradient(135deg,var(--secondary-color),var(--dark-color));color:white;padding:0.8rem 1rem;display:flex;justify-content:space-between;align-items:center;box-shadow:0 2px 10px rgba(0,0,0,0.1);z-index:100;position:relative;}
.nav-left{display:flex;align-items:center;}
.menu-toggle{font-size:1.2rem;margin-right:15px;cursor:pointer;}
.logo{font-size:1.1rem;font-weight:600;display:flex;align-items:center;}
.logo i{margin-right:8px;}
.user-info{display:flex;align-items:center;}
.user-info img{width:36px;height:36px;border-radius:50%;margin-right:8px;object-fit:cover;}
.logout-btn{background:var(--accent-color);color:white;border:none;padding:0.4rem 0.8rem;border-radius:5px;cursor:pointer;transition:all 0.3s;display:flex;align-items:center;font-size:0.9rem;}
.logout-btn:hover{background:#c0392b;}
.logout-btn i{margin-right:5px;}
.sidebar{position:fixed;top:0;left:-250px;width:250px;height:100%;background:linear-gradient(135deg,var(--secondary-color),var(--dark-color));color:white;padding:1rem 0;box-shadow:3px 0 10px rgba(0,0,0,0.1);z-index:200;transition:left 0.3s ease;}
.sidebar.show{left:0;}
.sidebar-header{padding:1rem 1.5rem;border-bottom:1px solid rgba(255,255,255,0.1);margin-bottom:1rem;display:flex;justify-content:space-between;align-items:center;}
.sidebar-header h2{font-size:1.2rem;font-weight:600;display:flex;align-items:center;}
.sidebar-header h2 i{margin-right:10px;font-size:1.5rem;}
.close-menu{font-size:1.5rem;cursor:pointer;}
.nav-item{padding:0.8rem 1.5rem;display:flex;align-items:center;transition:all 0.3s;cursor:pointer;color:#e0e0e0;}
.nav-item:hover,.nav-item.active{background:rgba(255,255,255,0.15);border-left:4px solid var(--primary-color);color:white;}
.nav-item i{margin-right:10px;font-size:1.1rem;}
.main-content{flex:1;overflow-y:auto;padding:1rem;-webkit-overflow-scrolling:touch;}
.header{display:flex;justify-content:space-between;align-items:center;margin-bottom:1.5rem;padding-bottom:0.8rem;border-bottom:1px solid #e0e0e0;}
.header h1{font-size:1.5rem;color:var(--secondary-color);margin-bottom:0.5rem;}
.welcome-text{color:#7f8c8d;font-size:0.9rem;}
.dashboard-cards{display:grid;grid-template-columns:1fr;gap:1rem;margin-bottom:1.5rem;}
.card{background:white;border-radius:10px;box-shadow:0 4px 10px rgba(0,0,0,0.08);padding:1.2rem;transition:transform 0.3s;}
.card:hover{transform:translateY(-3px);}
.card-header{display:flex;justify-content:space-between;align-items:center;margin-bottom:0.8rem;}
.card-icon{width:45px;height:45px;border-radius:10px;display:flex;align-items:center;justify-content:center;font-size:1.3rem;}
.card-icon.users{background:rgba(52,152,219,0.2);color:var(--primary-color);}
.card-icon.redis{background:rgba(220,53,69,0.2);color:#dc3545;}
.card-icon.alt{background:rgba(220,53,69,0.2);color:#dc3545;}
.card-title{font-size:0.9rem;color:#7f8c8d;margin-bottom:0.4rem;}
.card-value{font-size:1.5rem;font-weight:700;color:var(--secondary-color);}
.card-change{font-size:0.85rem;margin-top:0.4rem;display:flex;align-items:center;}
.card-change.positive{color:#2ecc71;}
.card-change.negative{color:var(--accent-color);}
.redis-details{display:grid;grid-template-columns:1fr 1fr;gap:0.5rem;margin-top:1rem;}
.redis-detail-item{font-size:0.85rem;}
.redis-detail-label{font-weight:600;color:#7f8c8d;}
.redis-detail-value{color:var(--secondary-color);}
.redis-section{margin-top:1rem;padding-top:1rem;border-top:1px solid #eee;}
.redis-section-title{font-weight:600;margin-bottom:0.5rem;color:var(--dark-color);}
.redis-keyspace-item{padding:0.3rem 0;}
.refresh-timer{position:relative;width:24px;height:24px;margin-left:10px;}
.refresh-circle{width:100%;height:100%;}
.refresh-number{position:absolute;top:50%;left:50%;transform:translate(-50%,-50%);font-size:0.7rem;font-weight:bold;}
.overlay{position:fixed;top:0;left:0;width:100%;height:100%;background:rgba(0,0,0,0.5);z-index:150;display:none;}
.overlay.show{display:block;}
#timerCircle{transition:stroke-dashoffset 0.5s ease-in-out;}
.redis-keyspace{display:grid;grid-template-columns:1fr 1fr;gap:0.5rem;}
.version-info{display:flex;justify-content:space-between;margin-top:1rem;padding-top:1rem;border-top:1px solid #eee;}
.version-label{font-weight:600;color:#7f8c8d;}
.version-value{color:var(--secondary-color);}
@media(min-width:576px){.dashboard-cards{grid-template-columns:repeat(2,1fr);}}
</style>
</head>
<body>
<div class="admin-container">
<div class="top-nav">
<div class="nav-left">
<div class="menu-toggle"><i class="fas fa-bars"></i></div>
<div class="logo"><i class="fas fa-tachometer-alt"></i><?php echo $currentTitle; ?></div>
</div>
<div class="user-info">
<button class="logout-btn" onclick="location.href='?logout=1'"><i class="fas fa-sign-out-alt"></i>退出</button>
</div>
</div>
<div class="sidebar" id="sidebar">
<div class="sidebar-header">
<h2><i class="fas fa-tachometer-alt"></i>管理面板</h2>
<div class="close-menu"><i class="fas fa-times"></i></div>
</div>
<a href="?page=dashboard" class="nav-item <?=$page=='dashboard'?'active':''?>"><i class="fas fa-home"></i>监控仪表</a>
<a href="?page=stats" class="nav-item <?=$page=='stats'?'active':''?>"><i class="fas fa-chart-bar"></i>统计分析</a>
<a href="?page=logs" class="nav-item <?=$page=='logs'?'active':''?>"><i class="fas fa-chart-bar"></i>日志管理</a>
<a href="?page=settings" class="nav-item <?=$page=='settings'?'active':''?>"><i class="fas fa-cog"></i>系统设置</a>
</div>
<div class="overlay" id="overlay"></div>
<div class="main-content">
<?php if($page=='dashboard'):?>
<div class="dashboard-cards">
<div class="card">
<div class="card-header" style="display: flex; align-items: center;">
  <div class="card-icon redis" style="margin-right: 12px;"><i class="fas fa-chart-bar"></i></div>
  <div>
    <span style="font-size: 1.2rem; font-weight: 600;">接口监控</span>
    <br>
    <small><a href='https://shop.autofaka.com//liebiao/36E43F3A62413223' style='text-decoration: none;' target='_blank'><font color='red'>点我获取卡密</font></a></small>
  </div>
</div>



<div class="redis-details">
<div class="redis-detail-item">
<span class="redis-detail-label">主力接口账户</span>
</div>
<div class="redis-detail-item">
<span class="redis-detail-label">辅助接口账户</span>
</div>
<div class="redis-detail-item">
<span class="redis-detail-value" id="ZLZHCS">正在请求…<br></span>
<font color='red' onclick="sykm(1)">卡密充值</font>
</div>
<div class="redis-detail-item">
<span class="redis-detail-value" id="FZZHCS">正在请求…<br></span>
<font color='red' onclick="sykm(1)">卡密充值</font>
</div>

</div></div>






<div class="card">


<div class="card-header" style="display: flex; align-items: center;">
  <div class="card-icon redis" style="margin-right: 12px;"><i class="fas fa-database"></i></div>
  <div><span style="font-size: 1.2rem; font-weight: 600;">Redis状态</span><br>
    <small>
<?php if($redisStatus['status']==='success'):?>
            <span>运行中</span></small></div>
</div>




<div id="redisStatusContent">
<div class="redis-details">
<div class="redis-detail-item">
<span class="redis-detail-label">运行时间:</span><br>
<span class="redis-detail-value" id="redisUptimeDisplay"><?php echo $redisStatus['uptime'];?></span>
</div>
<div class="redis-detail-item">
<span class="redis-detail-label">实时执行:</span>
<span class="redis-detail-value"><?php echo $redisStatus['stats']['instantaneous_ops'];?>次/秒</span>
</div>

<div class="redis-detail-item">
<span class="redis-detail-label">总执行:</span>
<span class="redis-detail-value"><?php echo number_format($redisStatus['stats']['total_commands']);?>次</span>
</div>
<div class="redis-detail-item">
<span class="redis-detail-label">累计节省:</span>
<span class="redis-detail-value"><?php echo number_format(intval($redisStatus['stats']['total_commands']*($redisStatus['hitRate']/100)));?>次</span>
</div>
<div class="redis-detail-item">
<span class="redis-detail-label">已用内存:</span>
<span class="redis-detail-value"><?php echo $redisStatus['memory']['used'];?></span>
</div>
<div class="redis-detail-item">
<span class="redis-detail-label">峰值内存:</span>
<span class="redis-detail-value"><?php echo $redisStatus['memory']['peak'];?></span>
</div>
</div>
<div class="redis-section">
<div class="redis-section-title">redis缓存统计</div>
<div class="redis-keyspace">
<?php foreach($redisStatus['keyspace']as$db=>$info):?>
<div class="redis-keyspace-item">
<strong>表<?php echo substr($db,2);?>存储量:</strong>
<?php 
$parts=explode(',',$info);
foreach($parts as$part){
if(strpos($part,'keys=')!==false){
echo str_replace('keys=','',$part).'个';
}
}
?>
</div>
<?php endforeach;?>
</div>
</div>
<?php else:?>
            <span>未连接</span></small></div>
</div>




<div id="redisStatusContent">
<div class="card-change negative"><?php echo $redisStatus['message'];?></div>
<?php endif;?>
</div>
</div>
</div>
<?php elseif($page=='stats'):?>

<div class="card">




<div class="card-header" style="display: flex; align-items: center;">
<div class="card-icon users" style="margin-right: 12px;"><i class="fas fa-users"></i>
</div>
  <span style="font-size: 1.2rem; font-weight: 600;">用户统计</span>
</div>

<div class="card-title">总用户数：<?php $data=json_decode(file_get_contents('user/'.APPID1.suffix),true);if($data===null){echo "0";}else{echo count(array_keys($data));}?>人</div>
<div class="card-title">今日活跃人数：<?php $c=0;foreach(scandir('user/')as$f){if($f!='.'&&$f!='..'){$p='user/'.$f;if(is_file($p)){$t=filemtime($p);if($t>=strtotime('today')&&$t<=strtotime('today 23:59:59'))$c++;}}}echo$c;?>人
</div>
</div>
    </div>
<br><br>
<?php elseif($page=='logs'):?>
<div class="card">
    <style>

        .log-container {
            background-color: #393D49;
            color: #1e9fff;
            border-radius: 5px;
            padding: 0px;
            height: 80vh;
            overflow: auto;
            font-family: 'Courier New', monospace;
            border: 1px solid #1e9fff;
            font-size: 13px;
            line-height: 1.4;
        }
        .log-container .layui-card-body {
            padding: 5px;
        }
        .control-panel {
            margin-bottom: 15px;
            text-align: right;
        }
        .log-line {
            display: flex;
            margin-bottom: 2px;
        }
        .line-number {
            color: #5FB878;
            min-width: 10px;
            text-align: right;
            padding-right: 10px;
            user-select: none;
            opacity: 0.7;
        }
        .log-content {
            flex: 1;
            white-space: pre-wrap;
            word-break: break-all;
        }
        @media screen and (max-width: 768px) {
            body {
                padding: 10px;
            }
            .log-container {
                height: 70vh;
                font-size: 12px;
            }
            .line-number {
                min-width: 30px;
                padding-right: 5px;
            }
            .log-container .layui-card-body {
                padding: 3px;
            }
        }
    </style>

<div class="card-header" style="display: flex; align-items: center;">
<div class="card-icon alt" style="margin-right: 12px;"><i class="fas fa-list-alt"></i></div>
<div><span style="font-size: 1.2rem; font-weight: 600;">实时日志</span><br>
    <small><span class="layui-badge-dot" id="connectionStatus"></span>
            <span id="statusText">连接中...</span></small>
</div></div>

        <div class="log-container layui-card">
            <div class="layui-card-body">
                <div id="logContent"></div>
            </div>
        </div>
    </div>
<br><br>
<?php elseif($page=='settings'):?>


<div class="card">


<div class="card-body">
<h6>系统设置</h6>
※redis时间设置大于一天可导致排盘AI功能无法使用！
<div class="version-info" style="white-space: nowrap;">
<div class="version-label" style="display: inline-block; margin-right: 10px; vertical-align: middle;">网站标题:</div>
<div class="version-value" style="display: inline-block;">
<input type="text" id="title" placeholder="标题" 
   style="width: auto; min-width: 150px; max-width: 150px; height: 30px; box-sizing: border-box; vertical-align: middle;"
   oninput="this.style.width = (this.value.length + 3) + 'ch';">
<button type="button" class="btn btn-primary" onclick="saveVersion('title')" 
style="height: 30px; padding: 5px 10px; box-sizing: border-box; vertical-align: middle;">保存</button>
</div>
</div>

<div class="version-info" style="white-space: nowrap;">
<div class="version-label" style="display: inline-block; margin-right: 10px; vertical-align: middle;">网站地址:</div>
<div class="version-value" style="display: inline-block;">
<input type="text" id="GF_URL" placeholder="网站url" 
   style="width: auto; min-width: 150px; max-width: 150px; height: 30px; box-sizing: border-box; vertical-align: middle;"
   oninput="this.style.width = (this.value.length + 3) + 'ch';">
<button type="button" class="btn btn-primary" onclick="saveVersion('GF_URL')" 
style="height: 30px; padding: 5px 10px; box-sizing: border-box; vertical-align: middle;">保存</button>
</div>
</div>

<div class="version-info" style="white-space: nowrap;">
<div class="version-label" style="display: inline-block; margin-right: 10px; vertical-align: middle;">刷新频率:</div>
<div class="version-value" style="display: inline-block;">
<input type="text" 
       id="GF_REFRESH_INTERVAL" 
       placeholder="仪表盘刷新秒数"
       style="width: auto; min-width: 150px; max-width: 150px; height: 30px; box-sizing: border-box; vertical-align: middle; border: 1px solid #ccc; padding: 5px;"
       oninput="$(this).val($(this).val().replace(/[^\d]/g,'')).css('border-color', $(this).val() ? '#4CAF50' : '#ccc'); this.style.width = (this.value.length + 3) + 'ch';">


<button type="button" class="btn btn-primary" onclick="saveVersion('GF_REFRESH_INTERVAL')" 
style="height: 30px; padding: 5px 10px; box-sizing: border-box; vertical-align: middle;">保存</button>
</div>
</div>


<div class="version-info" style="white-space: nowrap;">
<div class="version-label" style="display: inline-block; margin-right: 10px; vertical-align: middle;">接口选择：</div>
<div class="version-value" style="display: inline-block;">
<select id="URL" style="width: auto; min-width: 90px; max-width: 300px; height: 30px; box-sizing: border-box; vertical-align: middle;">

<option value="<?php echo JK_1;?>">中国大陆</option>
<option value="<?php echo JK_2;?>">港澳台</option>
<option value="<?php echo JK_3;?>">海外远点</option>
</select>
<button type="button" class="btn btn-primary" onclick="saveVersion('URL')" style="...">保存</button>&nbsp;<button type="button" class="btn btn-primary" onclick="saveVersion_CS('URL')" style="...">测速</button>
</div>
</div>



<div class="version-info" style="white-space: nowrap;">
<div class="version-label" style="display: inline-block; margin-right: 10px; vertical-align: middle;">APPID1:</div>
<div class="version-value" style="display: inline-block;">
<input type="text" id="APPID1" placeholder="APPID1" 
   style="width: auto; min-width: 150px; max-width: 150px; height: 30px; box-sizing: border-box; vertical-align: middle;"
   oninput="this.style.width = (this.value.length + 3) + 'ch';">
<button type="button" class="btn btn-primary" onclick="saveVersion('APPID1')" 
style="height: 30px; padding: 5px 10px; box-sizing: border-box; vertical-align: middle;">保存</button>
</div>
</div>

<div class="version-info" style="white-space: nowrap;">
<div class="version-label" style="display: inline-block; margin-right: 10px; vertical-align: middle;">APPKEY1:</div>
<div class="version-value" style="display: inline-block;">
<input type="text" id="APPKEY1" placeholder="APPKEY1" 
   style="width: auto; min-width: 150px; max-width: 150px; height: 30px; box-sizing: border-box; vertical-align: middle;"
   oninput="this.style.width = (this.value.length + 3) + 'ch';">
<button type="button" class="btn btn-primary" onclick="saveVersion('APPKEY1')" 
style="height: 30px; padding: 5px 10px; box-sizing: border-box; vertical-align: middle;">保存</button>
</div>
</div>


<div class="version-info" style="white-space: nowrap;">
<div class="version-label" style="display: inline-block; margin-right: 10px; vertical-align: middle;">APPID2:</div>
<div class="version-value" style="display: inline-block;">
<input type="text" id="APPID2" placeholder="APPID2" 
   style="width: auto; min-width: 150px; max-width: 150px; height: 30px; box-sizing: border-box; vertical-align: middle;"
   oninput="this.style.width = (this.value.length + 3) + 'ch';">
<button type="button" class="btn btn-primary" onclick="saveVersion('APPID2')" 
style="height: 30px; padding: 5px 10px; box-sizing: border-box; vertical-align: middle;">保存</button>
</div>
</div>

<div class="version-info" style="white-space: nowrap;">
<div class="version-label" style="display: inline-block; margin-right: 10px; vertical-align: middle;">APPKEY2:</div>
<div class="version-value" style="display: inline-block;">
<input type="text" id="APPKEY2" placeholder="APPKEY2" 
   style="width: auto; min-width: 150px; max-width: 150px; height: 30px; box-sizing: border-box; vertical-align: middle;"
   oninput="this.style.width = (this.value.length + 3) + 'ch';">
<button type="button" class="btn btn-primary" onclick="saveVersion('APPKEY2')" 
style="height: 30px; padding: 5px 10px; box-sizing: border-box; vertical-align: middle;">保存</button>
</div>
</div>






<div class="version-info" style="white-space: nowrap;">
<div class="version-label" style="display: inline-block; margin-right: 10px; vertical-align: middle;">redisIP:</div>
<div class="version-value" style="display: inline-block;">
<input type="text" id="redis_ip" placeholder="redis服务器IP" 
   style="width: auto; min-width: 150px; max-width: 150px; height: 30px; box-sizing: border-box; vertical-align: middle;"
   oninput="this.style.width = (this.value.length + 3) + 'ch';">
<button type="button" class="btn btn-primary" onclick="saveVersion('redis_ip')" 
style="height: 30px; padding: 5px 10px; box-sizing: border-box; vertical-align: middle;">保存</button>
</div>
</div><div class="version-info" style="white-space: nowrap;">
<div class="version-label" style="display: inline-block; margin-right: 10px; vertical-align: middle;">redis端口:</div>
<div class="version-value" style="display: inline-block;">
<input type="text" id="redis_dk" placeholder="redis服务器端口号" 
   style="width: auto; min-width: 150px; max-width: 150px; height: 30px; box-sizing: border-box; vertical-align: middle;"
   oninput="this.style.width = (this.value.length + 3) + 'ch';">
<button type="button" class="btn btn-primary" onclick="saveVersion('redis_dk')" 
style="height: 30px; padding: 5px 10px; box-sizing: border-box; vertical-align: middle;">保存</button>
</div>
</div><div class="version-info" style="white-space: nowrap;">
<div class="version-label" style="display: inline-block; margin-right: 10px; vertical-align: middle;">redis密码:</div>
<div class="version-value" style="display: inline-block;">
<input type="text" id="redis_auth" placeholder="redis服务器密码" 
   style="width: auto; min-width: 150px; max-width: 150px; height: 30px; box-sizing: border-box; vertical-align: middle;"
   oninput="this.style.width = (this.value.length + 3) + 'ch';">
<button type="button" class="btn btn-primary" onclick="saveVersion('redis_auth')" 
style="height: 30px; padding: 5px 10px; box-sizing: border-box; vertical-align: middle;">保存</button>
</div>
</div><div class="version-info" style="white-space: nowrap;">
<div class="version-label" style="display: inline-block; margin-right: 10px; vertical-align: middle;">redis库号:</div>
<div class="version-value" style="display: inline-block;">
<input type="text" id="redis_select" placeholder="redis数据库号" 
   style="width: auto; min-width: 150px; max-width: 150px; height: 30px; box-sizing: border-box; vertical-align: middle;"
   oninput="this.style.width = (this.value.length + 3) + 'ch';">
<button type="button" class="btn btn-primary" onclick="saveVersion('redis_select')" 
style="height: 30px; padding: 5px 10px; box-sizing: border-box; vertical-align: middle;">保存</button>
</div>
</div><div class="version-info" style="white-space: nowrap;">
<div class="version-label" style="display: inline-block; margin-right: 10px; vertical-align: middle;">redis时间:</div>
<div class="version-value" style="display: inline-block;">

<input type="text" 
       id="redis_ts" 
       placeholder="缓存天数"
       style="width: auto; min-width: 150px; max-width: 150px; height: 30px; box-sizing: border-box; vertical-align: middle; border: 1px solid #ccc; padding: 5px;"
       oninput="$(this).val($(this).val().replace(/[^\d]/g,'')).css('border-color', $(this).val() ? '#4CAF50' : '#ccc'); this.style.width = (this.value.length + 3) + 'ch';">


<button type="button" class="btn btn-primary" onclick="saveVersion('redis_ts')" 
style="height: 30px; padding: 5px 10px; box-sizing: border-box; vertical-align: middle;">保存</button>
</div>
</div>





<div class="version-info" style="white-space: nowrap;">
<div class="version-label" style="display: inline-block; margin-right: 10px; vertical-align: middle;">存储名:</div>
<div class="version-value" style="display: inline-block;">
<input type="text" id="suffix" placeholder="自定义存储名" 
   style="width: auto; min-width: 150px; max-width: 150px; height: 30px; box-sizing: border-box; vertical-align: middle;"
   oninput="this.style.width = (this.value.length + 3) + 'ch';">
<button type="button" class="btn btn-primary" onclick="saveVersion('suffix')" 
style="height: 30px; padding: 5px 10px; box-sizing: border-box; vertical-align: middle;">保存</button>
</div>
</div>



</div></div><br>
<div class="card">
<div class="card-body">
<p>版本管理</p>
<div class="version-info">
<div class="version-label">当前版本:</div>
<div class="version-value" id="currentVersion">最新版本</div>
</div>
<div class="version-info">
<div class="version-label">最后更新:</div>
<div class="version-value" id="lastUpdateTime"><?php echo GF_GXRQ;?></div>
</div>






</div>


</div>
<br><br>
<?php endif;?>
</div>
<script src="date/date/jquery.min3.7.1.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.1/js/bootstrap.bundle.min.js"></script>

<script src="date/date/layui/layui.js"></script>
    
    <script>
        layui.use(['element', 'layer'], function(){
            var element = layui.element;
            var layer = layui.layer;
            
            const $logContent = $('#logContent');
            const $connectionStatus = $('#connectionStatus');
            const $statusText = $('#statusText');
            
            let lineCount = 0;
            let autoScroll = true;
            let isConnected = false;
            let isFirstRequest = true; // 标记是否为首次请求

            


            function updateConnectionStatus(connected) {
                isConnected = connected;
                if (connected) {
                    $connectionStatus.removeClass('layui-bg-red').addClass('layui-bg-green');
                    $statusText.text('已连接');
                } else {
                    $connectionStatus.removeClass('layui-bg-green').addClass('layui-bg-red');
                    $statusText.text('连接中...');
                }
            }

            function addLogLine(content) {
let arr = content.split("：：");

                lineCount++;
                const lineElement = `
                    <div class="log-line" onclick="alert('请求时间:${arr[0]}\\n请求IP:${arr[1]}\\n请求形式:采用${arr[2]}获取\\n请求地址:${arr[3]}\\n')">
                        <div class="line-number">${lineCount}</div>
                        <div class="log-content">${content}</div>
                    </div>
                `;
                $logContent.prepend(lineElement);
                
                if (autoScroll) {
                    const container = $('.log-container')[0];
                    container.scrollTop = 0;
                }
            }

            // 定义长轮询函数
            function longPoll() {
                // 构建请求URL，首次请求添加first=1参数[1,2](@ref)
                let url = 'log_polling.php';
                if (isFirstRequest) {
                    url += '?first=1';
                    isFirstRequest = false; // 后续请求不再添加first参数
                }
                
                $.ajax({
                    url: url,
                    type: 'GET',
                    dataType: 'text',
                    timeout: 40000,
                    
                    success: function(newLogs) {
                        if (newLogs && newLogs !== 'No new data (timeout)') {
                            const logLines = newLogs.split('\n');
                            for (let i = logLines.length - 1; i >= 0; i--) {
                                if (logLines[i].trim() !== '') {
                                    addLogLine(logLines[i]);
                                }
                            }
                            updateConnectionStatus(true);
                        }
                        longPoll();
                    },
                    
                    error: function(xhr, status, error) {
                        console.error('长轮询请求出错: ' + status + ', ' + error);
                        updateConnectionStatus(false);
                        setTimeout(longPoll, 3000);
                    }
                });
            }
            
            // 启动长轮询
            longPoll();
            updateConnectionStatus(false);
        });
    </script>
<script>

function sykm(a){if(a!==1&&a!==2)return layer.msg('参数a只能为1或2',{icon:2,time:3000});var i=a===1?'<?php echo APPID1; ?>':'<?php echo APPID2; ?>',k=a===1?'<?php echo APPKEY1; ?>':'<?php echo APPKEY2; ?>',p=prompt("请输入卡密","请输入已购买的卡密");p&&$.ajax({url:'<?php echo GF_WWW; ?>Homepage.php?SYLX=alcr&id=drkmm&name='+p+'&APPID='+i+'&APPKEY='+k,type:'GET',dataType:'text',timeout:5000,success:function(r){r=JSON.parse(r);layer.msg(r.code,{icon:r.code.includes("错误")?2:1,time:5000});fetchApiData1();fetchApiData2();},error:function(){layer.msg('使用失败！',{icon:2,time:1500});}});}



var aa='<?php echo manageConfig();?>';

const jsonObj = JSON.parse(aa);
$('#title').val(jsonObj.title);
$('#GF_URL').val(jsonObj.GF_URL);
$('#APPID1').val(jsonObj.APPID1);
$('#APPKEY1').val(jsonObj.APPKEY1);
$('#APPID2').val(jsonObj.APPID2);
$('#APPKEY2').val(jsonObj.APPKEY2);
$("#URL").val(jsonObj.URL);
$("#suffix").val(jsonObj.suffix);
$("#redis_ip").val(jsonObj.redis_ip);
$("#redis_dk").val(jsonObj.redis_dk);
$("#redis_auth").val(jsonObj.redis_auth);
$("#redis_select").val(jsonObj.redis_select);
$("#redis_ts").val(jsonObj.redis_ts);
$("#GF_REFRESH_INTERVAL").val(jsonObj.GF_REFRESH_INTERVAL);



function saveVersion(a){
$.ajax({
url:'<?php echo $_SERVER['PHP_SELF'];?>?id=saveVersion&name='+a+'&value='+$("#"+a).val(),
type: 'GET',
dataType: 'text',
timeout: 5000,
success: function(response) {
layer.msg('保存成功！',{icon:1,time:1500});


},
error: function(xhr) {
layer.msg('保存失败！',{icon:2,time:1500});
}
});

}

function saveVersion_CS(a){
layer.msg('测速中请稍等……',{icon:1,time:5000});
$.ajax({
url:'<?php echo $_SERVER['PHP_SELF'];?>?id=jkcs',
type: 'GET',
dataType: 'text',
timeout: 15000,
success: function(response) {
$("#URL").val(response);
saveVersion('URL');
layer.msg('测速完成，已为您切换最优节点！',{icon:1,time:5000});


},
error: function(xhr) {
layer.msg('测速失败！',{icon:2,time:1500});
}
});

}



layui.use('layer',function(){var layer=layui.layer;});
$(document).ready(function(){
$('.menu-toggle').click(function(){$('#sidebar').addClass('show');$('#overlay').addClass('show');});
$('.close-menu,#overlay').click(function(){$('#sidebar').removeClass('show');$('#overlay').removeClass('show');});
$('.nav-item').click(function(){$('.nav-item').removeClass('active');$(this).addClass('active');$('#sidebar').removeClass('show');$('#overlay').removeClass('show');layer.msg('正在切换到:'+$(this).text(),{icon:1,time:1500});});
<?php if($page=='dashboard'):?>
var timer=10;
var circle=$('#timerCircle');
var number=$('#timerNumber');
var circumference=62.83;
var interval;

var refreshInterval = <?php echo GF_REFRESH_INTERVAL; ?>;
var timer = refreshInterval;

function startTimer(){
timer = refreshInterval;
number.text(timer);
circle.css('stroke-dashoffset', 0);

interval = setInterval(function(){
timer--;
number.text(timer);
var offset = circumference * (1 - timer / refreshInterval);
circle.css('stroke-dashoffset', offset);

if(timer <= 0){
clearInterval(interval);
refreshRedisStatus();
}
}, 1000);
}


function refreshRedisStatus(){
$.ajax({
url:'<?php echo $_SERVER['PHP_SELF'];?>?page=dashboard',
type:'GET',
dataType:'html',
success:function(data){
var newContent=$(data).find('#redisStatusContent').html();
$('#redisStatusContent').html(newContent);
fetchApiData1();
fetchApiData2();
startTimer();
}
});
}
function fetchApiData1() {
$.ajax({
url: '<?php echo GF_WWW; ?>api.php?ID=hqzt&APPID=<?php echo APPID1; ?>&APPKEY=<?php echo APPKEY1; ?>',
type: 'GET',
dataType: 'text',
timeout: 5000,
success: function(response) {
  $('#ZLZHCS').html(response);


},
error: function(xhr) {
$('#ZLZHCS').html('与源服务器通信失败');
}
});
}

function fetchApiData2() {
$.ajax({
url: '<?php echo GF_WWW; ?>api.php?ID=hqzt&APPID=<?php echo APPID2; ?>&APPKEY=<?php echo APPKEY2; ?>',
type: 'GET',
dataType: 'text',
timeout: 5000,
success: function(response) {
  $('#FZZHCS').html(response);


},
error: function(xhr) {
$('#FZZHCS').html('与源服务器通信失败');
}
});
}

startTimer();
fetchApiData1();
fetchApiData2();


<?php endif;?>
});
</script>
</body>
</html>
<?php }else{?>
<!DOCTYPE html>
<html lang="zh-CN">
<head>
<meta charset="UTF-8">
<meta name="viewport" content="width=device-width,initial-scale=1.0,maximum-scale=1.0,user-scalable=no">
<title>后台管理系统</title>
<link href="date/date/bootstrap.min5.3.1.css" rel="stylesheet">

<link rel="stylesheet" href="https://unpkg.com/swiper@11.2.10/swiper-bundle.min.css">

<link href="date/date/layui/css/layui.css" rel="stylesheet">
<style>
:root{--primary-color:#3498db;--secondary-color:#2c3e50;--accent-color:#e74c3c;--light-color:#ecf0f1;--dark-color:#2c3e50;}
*{margin:0;padding:0;box-sizing:border-box;}
body{font-family:'Segoe UI',Tahoma,Geneva,Verdana,sans-serif;background-color:var(--dark-color);height:100vh;overflow:hidden;display:flex;justify-content:center;align-items:center;position:relative;font-size:14px;}
.background-swiper{position:absolute;width:100%;height:100%;top:0;left:0;z-index:0;}
.swiper-slide{background-size:cover;background-position:center;opacity:0.15;}
.login-container{position:relative;z-index:10;width:100%;max-width:400px;padding:1rem;}
.login-card{background:rgba(255,255,255,0.95);border-radius:12px;box-shadow:0 8px 25px rgba(0,0,0,0.3);overflow:hidden;transition:transform 0.3s ease;}
.login-card:hover{transform:translateY(-3px);}
.card-header{background:linear-gradient(135deg,var(--primary-color),var(--secondary-color));color:white;text-align:center;padding:1.2rem;position:relative;}
.card-header h2{font-weight:600;margin-bottom:0.4rem;font-size:1.3rem;}
.card-header p{font-size:0.9rem;}
.card-header::after{content:'';position:absolute;bottom:0;left:0;width:100%;height:3px;background:linear-gradient(90deg,var(--accent-color),transparent);}
.card-body{padding:1.5rem;}
.form-group{margin-bottom:1.2rem;position:relative;}
.form-label{display:block;margin-bottom:0.4rem;font-weight:500;color:var(--dark-color);font-size:0.95rem;}
.form-control{width:100%;padding:0.7rem 1rem;border:2px solid #ddd;border-radius:8px;font-size:0.95rem;transition:all 0.3s;}
.form-control:focus{border-color:var(--primary-color);box-shadow:0 0 0 3px rgba(52,152,219,0.2);outline:none;}
.input-icon{position:absolute;right:15px;top:36px;color:#aaa;}
.btn-login{width:100%;padding:0.7rem;background:linear-gradient(135deg,var(--primary-color),var(--secondary-color));border:none;border-radius:8px;color:white;font-size:1rem;font-weight:600;cursor:pointer;transition:all 0.3s;margin-top:0.8rem;}
.btn-login:hover{background:linear-gradient(135deg,#2980b9,#1a2530);transform:translateY(-2px);box-shadow:0 4px 12px rgba(0,0,0,0.2);}
.forgot-password{display:block;text-align:right;margin-top:0.4rem;color:var(--primary-color);text-decoration:none;font-size:0.85rem;}
.forgot-password:hover{text-decoration:underline;}
.error-message{color:var(--accent-color);font-size:0.8rem;margin-top:0.2rem;display:none;}
.footer{text-align:center;margin-top:1rem;color:var(--light-color);font-size:0.8rem;}
.logo{width:50px;height:50px;background:white;border-radius:50%;display:flex;align-items:center;justify-content:center;margin:0 auto 0.8rem;box-shadow:0 4px 12px rgba(0,0,0,0.2);}
.logo i{font-size:1.8rem;color:var(--primary-color);}
.error-alert{background:rgba(231,76,60,0.1);border:1px solid rgba(231,76,60,0.3);border-radius:8px;padding:0.7rem;margin-bottom:1.2rem;color:var(--accent-color);display:flex;align-items:center;font-size:0.9rem;}
.error-alert i{margin-right:8px;font-size:1.1rem;}
@media(max-width:576px){.login-container{padding:0.8rem;}.login-card{border-radius:10px;}.card-body{padding:1.2rem;}}
</style>
</head>
<body>
<div class="swiper background-swiper">
<div class="swiper-wrapper">
<div class="swiper-slide" style="background-image:url('https://images.unsplash.com/photo-1497366754035-f200968a6e72?ixlib=rb-4.0.3&auto=format&fit=crop&w=1950&q=80')"></div>
<div class="swiper-slide" style="background-image:url('https://images.unsplash.com/photo-1550745165-9bc0b252726f?ixlib=rb-4.0.3&auto=format&fit=crop&w=1950&q=80')"></div>
<div class="swiper-slide" style="background-image:url('https://images.unsplash.com/photo-1517245386807-bb43f82c33c4?ixlib=rb-4.0.3&auto:format&fit=crop&w=1950&q=80')"></div>
</div>
</div>
<div class="login-container">
<div class="login-card">
<div class="card-header">
<h2>后台登录</h2>
</div>
<div class="card-body">
<?php if(isset($error_message)):?>
<div class="error-alert"><i class="layui-icon layui-icon-face-cry"></i><?php echo $error_message;?></div>
<?php endif;?>
<form id="loginForm" method="POST">
<div class="form-group">
<input type="text" id="username" name="username" class="form-control" placeholder="APPID" value="<?php echo isset($_POST['username'])?htmlspecialchars($_POST['username']):'';?>">
<div class="error-message" id="username-error">请输入有效的APPID</div>
</div>
<div class="form-group">
<input type="password" id="password" name="password" class="form-control" placeholder="请输入APPKEY">
<div class="error-message" id="password-error">APPKEY长度至少为6位</div>
</div>
<button type="submit" class="btn-login">登录系统</button>
</form>
</div>
</div>
</div>
<script src="date/date/jquery.min3.7.1.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.3.1/js/bootstrap.bundle.min.js"></script>
<script src="https://unpkg.com/swiper@11.2.10/swiper-bundle.min.js"></script>

<script src="date/date/layui/layui.js"></script>
<script>

layui.use('form',function(){var form=layui.form;form.render();});
var swiper=new Swiper('.background-swiper',{effect:'fade',loop:true,autoplay:{delay:5000,disableOnInteraction:false},speed:1500});
$(document).ready(function(){
$('#loginForm').on('submit',function(e){
e.preventDefault();
$('.error-message').hide();
$('.form-control').removeClass('is-invalid');
var username=$('#username').val().trim();
var password=$('#password').val().trim();
var isValid=true;
if(username===''){$('#username-error').show();$('#username').addClass('is-invalid');isValid=false;}
if(password===''||password.length<6){$('#password-error').show();$('#password').addClass('is-invalid');isValid=false;}
if(isValid){
var btn=$(this).find('.btn-login');
btn.html('<i class="layui-icon layui-icon-loading layui-anim layui-anim-rotate"></i>登录中...');
btn.prop('disabled',true);
this.submit();}});
$('#username').on('input',function(){if($(this).val().trim()!==''){$(this).removeClass('is-invalid');$('#username-error').hide();}});
$('#password').on('input',function(){if($(this).val().trim().length>=6){$(this).removeClass('is-invalid');$('#password-error').hide();}});});
</script>

</body>
</html>
<?php }?>
